/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xloader.h
 * -----------------------------------------------------------------*/

/* This file defines the commands for the Mephisto loader.
 * They are used to program the power-up behavior of the card.
 */

#ifndef XBX_LOADER_H_INCLUDED
#define XBX_LOADER_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

/* One flash section (64KB) for loader code */
#define BX_LOADER_CODELENGTH 0x10000

/* -----------------------------------------------------------------
 * Loader commands
 * -----------------------------------------------------------------*/

/* Read */
#define BX_LOADER_READLONG            0x00
#define BX_LOADER_READWORD            0x02
#define BX_LOADER_READBYTE            0x01

/* Read [A0]->D0 */
#define BX_LOADER_READLONG_A0D0       0x10
#define BX_LOADER_READWORD_A0D0       0x12
#define BX_LOADER_READBYTE_A0D0       0x11

/* Read [A0++]->D0 */
#define BX_LOADER_READLONG_A0D0_INCR  0x20
#define BX_LOADER_READWORD_A0D0_INCR  0x22
#define BX_LOADER_READBYTE_A0D0_INCR  0x21

/* Read [A0]->D1 */
#define BX_LOADER_READLONG_A0D1       0x18
#define BX_LOADER_READWORD_A0D1       0x1A
#define BX_LOADER_READBYTE_A0D1       0x19

/* Read [A0++]->D1 */
#define BX_LOADER_READLONG_A0D1_INCR  0x28
#define BX_LOADER_READWORD_A0D1_INCR  0x2A
#define BX_LOADER_READBYTE_A0D1_INCR  0x29

/* Write */
#define BX_LOADER_WRITELONG           0x80
#define BX_LOADER_WRITEWORD           0x82
#define BX_LOADER_WRITEBYTE           0x81

/* Write D0->[A1] */
#define BX_LOADER_WRITELONG_D0A1      0x94
#define BX_LOADER_WRITEWORD_D0A1      0x96
#define BX_LOADER_WRITEBYTE_D0A1      0x95

/* Write D0->[A1++] */
#define BX_LOADER_WRITELONG_D0A1_INCR 0xA4
#define BX_LOADER_WRITEWORD_D0A1_INCR 0xA6
#define BX_LOADER_WRITEBYTE_D0A1_INCR 0xA5

/* Write D1->[A1] */
#define BX_LOADER_WRITELONG_D1A1      0x9C
#define BX_LOADER_WRITEWORD_D1A1      0x9E
#define BX_LOADER_WRITEBYTE_D1A1      0x9D

/* Write D1->[A1++] */
#define BX_LOADER_WRITELONG_D1A1_INCR 0xAC
#define BX_LOADER_WRITEWORD_D1A1_INCR 0xAE
#define BX_LOADER_WRITEBYTE_D1A1_INCR 0xAD

/* Write Mask */
#define BX_LOADER_MASKWRITELONG       0x40
#define BX_LOADER_MASKWRITEWORD       0x42
#define BX_LOADER_MASKWRITEBYTE       0x41

/* Compare */
#define BX_LOADER_COMPARELONG         0xD0
#define BX_LOADER_COMPAREWORD         0xD2
#define BX_LOADER_COMPAREBYTE         0xD1

/* Branch */
#define BX_LOADER_BRANCHEQUAL         0xE3
#define BX_LOADER_BRANCHNOTEQUAL      0xE7

/* Loop */
#define BX_LOADER_DONTIMESBYTE        0xC3
#define BX_LOADER_DONTIMESWORD        0xC0
#define BX_LOADER_ENDDONTIMES         0xC7

/* Load address registers */
#define BX_LOADER_LOADA0              0x30
#define BX_LOADER_LOADA1              0x34

/* No operation */
#define BX_LOADER_NOP                 0xEB

/* Program end */
#define BX_LOADER_END                 0xFF

/* Loader macros */
#define BX_LOADERCMD_READLONG(code,address,numbytes) \
        (code)[0] = BX_LOADER_READLONG;              \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);            \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);            \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);            \
        (numbytes)+=4;

#define BX_LOADERCMD_READWORD(code,address,numbytes) \
        (code)[0] = BX_LOADER_READWORD;              \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);            \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);            \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);            \
        (numbytes)+=4;

#define BX_LOADERCMD_READBYTE(code,address,numbytes) \
        (code)[0] = BX_LOADER_READBYTE;              \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);            \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);            \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);            \
        (numbytes)+=4;

#define BX_LOADERCMD_WRITELONG(code,address,data,numbytes) \
        (code)[0] = BX_LOADER_WRITELONG;                   \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);                  \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);                  \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);                  \
        (code)[4] = (bx_int8) ((data)   >>24 & 0xff);                  \
        (code)[5] = (bx_int8) ((data)   >>16 & 0xff);                  \
        (code)[6] = (bx_int8) ((data)   >>8  & 0xff);                  \
        (code)[7] = (bx_int8) ((data)   >>0  & 0xff);                  \
        (numbytes)+=8;

#define BX_LOADERCMD_WRITEWORD(code,address,data,numbytes) \
        (code)[0] = BX_LOADER_WRITEWORD;                   \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);                  \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);                  \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);                  \
        (code)[4] = (bx_int8) ((data)   >>8  & 0xff);                  \
        (code)[5] = (bx_int8) ((data)   >>0  & 0xff);                  \
        (numbytes)+=6;

#define BX_LOADERCMD_WRITEBYTE(code,address,data,numbytes) \
        (code)[0] = BX_LOADER_WRITEBYTE;                   \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);                  \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);                  \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);                  \
        (code)[4] = (bx_int8) (0);  /* unused */                       \
        (code)[5] = (bx_int8) ((data)   >>0  & 0xff);                  \
        (numbytes)+=6;

#define BX_LOADERCMD_MASKWRITELONG(code,address,data,mask,numbytes) \
        (code)[0] = BX_LOADER_MASKWRITELONG;                   \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);                  \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);                  \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);                  \
        (code)[4] = (bx_int8) ((data)   >>24 & 0xff);                  \
        (code)[5] = (bx_int8) ((data)   >>16 & 0xff);                  \
        (code)[6] = (bx_int8) ((data)   >>8  & 0xff);                  \
        (code)[7] = (bx_int8) ((data)   >>0  & 0xff);                  \
        (code)[8] = (bx_int8) ((mask)   >>24 & 0xff);                  \
        (code)[9] = (bx_int8) ((mask)   >>16 & 0xff);                  \
        (code)[10]= (bx_int8) ((mask)   >>8  & 0xff);                  \
        (code)[11]= (bx_int8) ((mask)   >>0  & 0xff);                  \
        (numbytes)+=12;

#define BX_LOADERCMD_MASKWRITEWORD(code,address,data,mask,numbytes) \
        (code)[0] = BX_LOADER_MASKWRITEWORD;                        \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);                           \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);                           \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);                           \
        (code)[4] = (bx_int8) ((data)   >>8  & 0xff);                           \
        (code)[5] = (bx_int8) ((data)   >>0  & 0xff);                           \
        (code)[6] = (bx_int8) ((mask)   >>8  & 0xff);                           \
        (code)[7] = (bx_int8) ((mask)   >>0  & 0xff);                           \
        (numbytes)+=8;

#define BX_LOADERCMD_MASKWRITEBYTE(code,address,data,mask,numbytes) \
        (code)[0] = BX_LOADER_MASKWRITEBYTE;                        \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);                           \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);                           \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);                           \
        (code)[4] = (bx_int8) ((data)   >>0  & 0xff);                           \
        (code)[5] = (bx_int8) ((mask)   >>0  & 0xff);                           \
        (numbytes)+=6;

#define BX_LOADERCMD_COMPAREBYTE(code,data,mask,numbytes)   \
        (code)[0]=BX_LOADER_COMPAREBYTE;                    \
        (code)[1]=(bx_int8) (0); /* unused */       \
        (code)[2] = (bx_int8) ((data)   >>0  & 0xff);   \
        (code)[3] = (bx_int8) ((mask)   >>0  & 0xff);   \
        (numbytes)+=4; 

#define BX_LOADERCMD_COMPAREWORD(code,data,mask,numbytes)   \
        (code)[0] = BX_LOADER_COMPAREWORD;                    \
        (code)[1] = (bx_int8) (0); /* unused */       \
        (code)[2] = (bx_int8) ((data)   >>8  & 0xff); \
        (code)[3] = (bx_int8) ((data)   >>0  & 0xff); \
        (code)[4] = (bx_int8) ((mask)   >>8  & 0xff); \
        (code)[5] = (bx_int8) ((mask)   >>0  & 0xff); \
        (numbytes)+=6; 

#define BX_LOADERCMD_COMPARELONG(code,data,mask,numbytes)   \
        (code)[0] = BX_LOADER_COMPARELONG;                    \
        (code)[1] = (bx_int8) (0); /* unused */       \
        (code)[2] = (bx_int8) ((data)   >>24 & 0xff);                  \
        (code)[3] = (bx_int8) ((data)   >>16 & 0xff);                  \
        (code)[4] = (bx_int8) ((data)   >>8  & 0xff);                  \
        (code)[5] = (bx_int8) ((data)   >>0  & 0xff);                  \
        (code)[6] = (bx_int8) ((mask)   >>24 & 0xff);                  \
        (code)[7] = (bx_int8) ((mask)   >>16 & 0xff);                  \
        (code)[8]=  (bx_int8) ((mask)   >>8  & 0xff);                  \
        (code)[9]=  (bx_int8) ((mask)   >>0  & 0xff);                  \
        (numbytes)+=10; 

#define BX_LOADERCMD_BRANCHNOTEQUAL(code,address,numbytes) \
        (code)[0] = BX_LOADER_BRANCHNOTEQUAL;              \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);            \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);            \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);            \
        (numbytes)+=4;

#define BX_LOADERCMD_BRANCHEQUAL(code,address,numbytes) \
        (code)[0] = BX_LOADER_BRANCHEQUAL;              \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);            \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);            \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);            \
        (numbytes)+=4;

#define BX_LOADERCMD_NOP(code,comment,numbytes)       \
        (code)[0]=BX_LOADER_NOP;                      \
        (code)[1]=(bx_int8) (comment);                \
        (numbytes)+=2; 

#define BX_LOADERCMD_END(code,comment,numbytes)    \
        (code)[0]=BX_LOADER_END;                   \
        (code)[1]=(bx_int8) (comment);             \
        (numbytes)+=2; 

#define BX_LOADERCMD_DONTIMESBYTE(code,n,numbytes) \
        (code)[0]=BX_LOADER_DONTIMESBYTE;          \
        (code)[1]=(bx_int8) (n);                   \
        (numbytes)+=2; 

#define BX_LOADERCMD_DONTIMESWORD(code,n,numbytes) \
        (code)[0]=BX_LOADER_DONTIMESWORD;          \
        (code)[1]=(bx_int8) (0); /* unused */      \
        (code)[2] = (bx_int8) ((n)>>8  & 0xff);    \
        (code)[3] = (bx_int8) ((n)>>0  & 0xff);    \
        (numbytes)+=4;

#define BX_LOADERCMD_ENDDONTIMES(code,numbytes)     \
        (code)[0]=BX_LOADER_ENDDONTIMES;            \
        (code)[1]=(bx_int8) (0); /* unused */       \
        (numbytes)+=2; 

#define BX_LOADERCMD_LOADA0(code,address,numbytes)     \
        (code)[0]=BX_LOADER_LOADA0;                    \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);  \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);  \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);  \
        (numbytes)+=4; 

#define BX_LOADERCMD_LOADA1(code,address,numbytes)     \
        (code)[0]=BX_LOADER_LOADA1;                    \
        (code)[1] = (bx_int8) ((address)>>16 & 0xff);  \
        (code)[2] = (bx_int8) ((address)>>8  & 0xff);  \
        (code)[3] = (bx_int8) ((address)>>0  & 0xff);  \
        (numbytes)+=4; 

#define BX_LOADERCMD_READBYTE_A0D0(code,numbytes)     \
        (code)[0]=BX_LOADER_READBYTE_A0D0;            \
        (code)[1]=(bx_int8) (0);    /* unused */      \
        (numbytes)+=2; 

#define BX_LOADERCMD_READWORD_A0D0(code,numbytes)     \
        (code)[0]=BX_LOADER_READWORD_A0D0;            \
        (code)[1]=(bx_int8) (0);    /* unused */      \
        (numbytes)+=2; 

#define BX_LOADERCMD_READLONG_A0D0(code,numbytes)     \
        (code)[0]=BX_LOADER_READLONG_A0D0;            \
        (code)[1]=(bx_int8) (0);    /* unused */      \
        (numbytes)+=2; 

#define BX_LOADERCMD_READBYTE_A0D1(code,numbytes)     \
        (code)[0]=BX_LOADER_READBYTE_A0D1;            \
        (code)[1]=(bx_int8) (0);    /* unused */      \
        (numbytes)+=2; 

#define BX_LOADERCMD_READWORD_A0D1(code,numbytes)     \
        (code)[0]=BX_LOADER_READWORD_A0D1;            \
        (code)[1]=(bx_int8) (0);    /* unused */      \
        (numbytes)+=2; 

#define BX_LOADERCMD_READLONG_A0D1(code,numbytes)     \
        (code)[0]=BX_LOADER_READLONG_A0D1;            \
        (code)[1]=(bx_int8) (0);    /* unused */      \
        (numbytes)+=2; 

#define BX_LOADERCMD_WRITEBYTE_D0A1(code,numbytes)     \
        (code)[0]=BX_LOADER_WRITEBYTE_D0A1;            \
        (code)[1]=(bx_int8) (0);    /* unused */       \
        (numbytes)+=2; 

#define BX_LOADERCMD_WRITEWORD_D0A1(code,numbytes)     \
        (code)[0]=BX_LOADER_WRITEWORD_D0A1;            \
        (code)[1]=(bx_int8) (0);    /* unused */       \
        (numbytes)+=2; 

#define BX_LOADERCMD_WRITELONG_D0A1(code,numbytes)     \
        (code)[0]=BX_LOADER_WRITELONG_D0A1;            \
        (code)[1]=(bx_int8) (0);    /* unused */       \
        (numbytes)+=2; 

#define BX_LOADERCMD_WRITEBYTE_D1A1(code,numbytes)     \
        (code)[0]=BX_LOADER_WRITEBYTE_D1A1;            \
        (code)[1]=(bx_int8) (0);    /* unused */       \
        (numbytes)+=2; 

#define BX_LOADERCMD_WRITEWORD_D1A1(code,numbytes)     \
        (code)[0]=BX_LOADER_WRITEWORD_D1A1;            \
        (code)[1]=(bx_int8) (0);    /* unused */       \
        (numbytes)+=2; 

#define BX_LOADERCMD_WRITELONG_D1A1(code,numbytes)     \
        (code)[0]=BX_LOADER_WRITELONG_D1A1;            \
        (code)[1]=(bx_int8) (0);    /* unused */       \
        (numbytes)+=2; 

/* Loader helpers */

/* This macro wastes some time (about 1us per NOP) */
#define BX_LOADERCMD_NOPWAIT(code,n,dummy,numbytes)      \
        BX_LOADERCMD_DONTIMESWORD((code),(n),(numbytes)) \
        BX_LOADERCMD_NOP((code),(dummy),(numbytes))      \
        BX_LOADERCMD_ENDDONTIMES((code),(numbytes))

/* Uses the unused byte of the NOP command for a comment,
   e.g. a counter value. 
   You may want to #define this one to (0) in the RELEASE
   version. */
#define BX_LOADERCMD_COMMENT(code,comment,numbytes)      \
        BX_LOADERCMD_NOP((code),(comment),(numbytes))          
        
#ifdef __cplusplus
}
#endif


#endif






